function [es]=bar2s(ex,ep,ed)
// es=bar2s(ex,ey,ep,ed)
//-------------------------------------------------------------
// PURPOSE
//  Compute normal force in two dimensional bar element.
//
// INPUT:  ex = [x1 x2]        element coordinates
//
//         ep = [E A]          E : Young's modulus
//                             A : Cross section area
//
//         ed : [u1 u2]  element displacement vector
//
// OUTPUT: es = [N]            element force 
//-------------------------------------------------------------
// LAST MODIFIED: T. Jankowiak 2010

   E=ep(1);  A=ep(2);
   b=[ex(2)-ex(1)];
   L=sqrt(b*b);
   u=ed';
   P1 = (E*A/L*[-1 1]*u)';
   es=P1
endfunction

